<?php
// maybank_gold_live.php
// Fetch and display Maybank's current gold & silver prices with auto-refresh and chart

date_default_timezone_set('Asia/Kuala_Lumpur');
$url = "https://www.maybank2u.com.my/maybank2u/malaysia/en/personal/rates/gold_and_silver.page";

$html = @file_get_contents($url);
if (!$html) {
    die("<p style='color:red;'>Error: Unable to fetch Maybank data.</p>");
}

preg_match('/Gold Investment Account \(per g\).*?RM ([\d.,]+).*?RM ([\d.,]+)/u', $html, $gold);
preg_match('/Islamic Gold Account-i.*?100 g and above.*?RM ([\d.,]+).*?RM ([\d.,]+)/u', $html, $miga);
preg_match('/Silver Investment Account \(per g\).*?RM ([\d.,]+).*?RM ([\d.,]+)/u', $html, $silver);

$date = date("l, d F Y - h:i A");
$gold_sell = $gold[1] ?? 0;
$gold_buy  = $gold[2] ?? 0;

$file = __DIR__ . "/gold_live_history.json";
$data = file_exists($file) ? json_decode(file_get_contents($file), true) : [];
$data[] = ["time" => date("H:i"), "sell" => (float)$gold_sell, "buy" => (float)$gold_buy];
if (count($data) > 24) array_shift($data);
file_put_contents($file, json_encode($data));
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Maybank Gold & Silver Prices</title>
  <meta http-equiv="refresh" content="300">
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  <style>
    body { font-family: Arial, sans-serif; background: #fafafa; color: #222; text-align: center; margin: 40px; }
    h1 { color: #d4af37; }
    table { border-collapse: collapse; margin: 20px auto; min-width: 500px; background: #fff; box-shadow: 0 2px 6px rgba(0,0,0,0.1); }
    th, td { padding: 10px 16px; border-bottom: 1px solid #ddd; }
    th { background: #f9f9f9; color: #444; }
    tr:hover { background: #fff8dc; }
    .footer { margin-top: 20px; font-size: 0.9em; color: #666; }
    canvas { max-width: 800px; margin-top: 40px; }
  </style>
</head>
<body>
  <h1>🏦 Maybank Live Gold & Silver Prices</h1>
  <p>Last updated: <?= $date ?></p>

  <table>
    <tr><th>Type</th><th>Selling (RM)</th><th>Buying (RM)</th></tr>
    <tr><td>Gold Investment Account (per g)</td><td><?= $gold_sell ?></td><td><?= $gold_buy ?></td></tr>
    <tr><td>Islamic Gold Account-i (≥100 g)</td><td><?= $miga[1] ?? '-' ?></td><td><?= $miga[2] ?? '-' ?></td></tr>
    <tr><td>Silver Investment Account (per g)</td><td><?= $silver[1] ?? '-' ?></td><td><?= $silver[2] ?? '-' ?></td></tr>
  </table>

  <canvas id="goldChart"></canvas>

  <div class="footer">
    Auto-refreshes every 5 minutes<br>
    Source: <a href="https://www.maybank2u.com.my/maybank2u/malaysia/en/personal/rates/gold_and_silver.page" target="_blank">Maybank2u Gold & Silver Rates</a>
  </div>

  <script>
    const goldData = <?= json_encode($data) ?>;
    const labels = goldData.map(d => d.time);
    const sellData = goldData.map(d => d.sell);
    const buyData = goldData.map(d => d.buy);

    new Chart(document.getElementById('goldChart'), {
      type: 'line',
      data: {
        labels: labels,
        datasets: [
          { label: 'Gold Sell (RM/g)', data: sellData, borderColor: 'gold', backgroundColor: 'rgba(255,215,0,0.3)', fill: false },
          { label: 'Gold Buy (RM/g)', data: buyData, borderColor: 'orange', backgroundColor: 'rgba(255,165,0,0.3)', fill: false }
        ]
      },
      options: {
        plugins: { legend: { position: 'top' } },
        scales: {
          x: { title: { display: true, text: 'Time (Today)' } },
          y: { title: { display: true, text: 'RM per gram' }, beginAtZero: false }
        }
      }
    });
  </script>
</body>
</html>
