<?php
// kfh_gold_live.php
// Fetch and display KFH Malaysia's live gold prices

date_default_timezone_set('Asia/Kuala_Lumpur');
$url = "https://www.kfh.com.my/malaysia/personal/tools-and-services/calculators/gold-calculator.html";

$html = @file_get_contents($url);
if (!$html) {
    die("<p style='color:red;'>Error: Unable to fetch data from KFH website.</p>");
}

preg_match('/Selling Price[^\d]*([\d.,]+)/i', $html, $sell);
preg_match('/Buying Price[^\d]*([\d.,]+)/i', $html, $buy);

$sell_price = isset($sell[1]) ? str_replace(',', '', $sell[1]) : '-';
$buy_price  = isset($buy[1]) ? str_replace(',', '', $buy[1]) : '-';
$date = date("l, d F Y - h:i A");
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>KFH Malaysia Gold Price</title>
  <meta http-equiv="refresh" content="300">
  <style>
    body { font-family: Arial, sans-serif; background: #f9fafb; color: #222; text-align: center; margin: 40px; }
    h1 { color: #008000; }
    table { border-collapse: collapse; margin: 30px auto; min-width: 400px; background: #fff; box-shadow: 0 2px 8px rgba(0,0,0,0.1); }
    th, td { padding: 12px 18px; border-bottom: 1px solid #ddd; }
    th { background: #e6f4ea; }
    tr:hover { background: #f7fff8; }
    .footer { margin-top: 20px; font-size: 0.9em; color: #555; }
  </style>
</head>
<body>
  <h1>🏦 KFH Malaysia Live Gold Price</h1>
  <p>Last updated: <?= $date ?></p>

  <table>
    <tr><th>Type</th><th>Price (RM)</th></tr>
    <tr><td><b>Selling Price</b> (per gram)</td><td><?= $sell_price ?></td></tr>
    <tr><td><b>Buying Price</b> (per gram)</td><td><?= $buy_price ?></td></tr>
  </table>

  <div class="footer">
    Auto-refreshes every 5 minutes<br>
    Source: <a href="https://www.kfh.com.my/malaysia/personal/tools-and-services/calculators/gold-calculator.html" target="_blank">KFH Malaysia Gold Calculator</a>
  </div>
</body>
</html>
